// Author: Kevin Scroggins
// Email: nitro404@hotmail.com
// Date: September 18, 2008

#ifndef _VECTOR_H
#define _VECTOR_H

#include <string>
#include <stdio.h>
#include <fstream>

using namespace std;

template <class T>
class Vector {
public:
	//constructors
	Vector<T>(int initial_size = 10);
	Vector<T>(const Vector<T> &v); // copy constructor
	Vector<T> & operator = (const Vector<T> &v); // assignment constructor
	~Vector<T>(); // destructor

	//vector manipulation methods
	Vector<T> &add(T & element);
	Vector<T> &add(T & element, int index);
	Vector<T> &remove(const T & element);
	T &elementAt(int index) const;
	int size() const;
	bool contains(const T & element) const;
	int indexOf(const T & x) const;
	int indexOf(const T & x, int index) const;
	bool isEmpty(void) const;
	void clear(void);

	//equality operator overrides
	bool operator == (const Vector<T> &v) const;
	bool operator != (const Vector<T> &v) const;

	//print to stream method
	void printOn(ostream &o) const;

private:
	int numberOfElements; //number of elements in the vector
	int capacity; //max. no of elements the vector can current memory can hold
	T ** elements; // element storage
};

template <class T>
ostream &operator << (ostream &o, const Vector<T> &v);

#endif